/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReinforcedButtonBlock
extends BlockButton
implements IReinforcedBlock {
    private final boolean isWooden;
    private final float destroyTimeForOwner;

    public ReinforcedButtonBlock(boolean isWooden) {
        super(isWooden);
        this.func_149722_s();
        if (isWooden) {
            this.func_149672_a(SoundType.field_185848_a);
        }
        this.isWooden = isWooden;
        this.destroyTimeForOwner = this.getVanillaBlocks().get((int)0).field_149782_v;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.func_180647_a(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess level, BlockPos pos) {
        return this.convertToVanillaState(state).func_185909_g(level, pos);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isAllowedToPress((AllowlistOnlyBlockEntity)world.func_175625_s(pos), player)) {
            return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean isAllowedToPress(AllowlistOnlyBlockEntity te, EntityPlayer entity) {
        return te.isOwnedBy((Entity)entity) || te.isAllowed((Entity)entity);
    }

    protected void func_185615_a(EntityPlayer player, World world, BlockPos pos) {
        world.func_184133_a(player, pos, this.isWooden ? SoundEvents.field_187885_gS : SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
    }

    protected void func_185617_b(World world, BlockPos pos) {
        world.func_184133_a(null, pos, this.isWooden ? SoundEvents.field_187883_gR : SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (!ConfigHandler.vanillaToolBlockBreaking && te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new AllowlistOnlyBlockEntity();
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.isWooden ? Blocks.field_150471_bO : Blocks.field_150430_aB);
    }
}

